/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL44C;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class ARBBufferStorage {
    public static final int GL_MAP_PERSISTENT_BIT = 64;
    public static final int GL_MAP_COHERENT_BIT = 128;
    public static final int GL_DYNAMIC_STORAGE_BIT = 256;
    public static final int GL_CLIENT_STORAGE_BIT = 512;
    public static final int GL_BUFFER_IMMUTABLE_STORAGE = 33311;
    public static final int GL_BUFFER_STORAGE_FLAGS = 33312;
    public static final int GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT = 16384;

    protected ARBBufferStorage() {
        throw new UnsupportedOperationException();
    }

    public static void nglBufferStorage(int target, long size, long data, int flags) {
        GL44C.nglBufferStorage((int)target, (long)size, (long)data, (int)flags);
    }

    public static void glBufferStorage(@NativeType(value="GLenum") int target, @NativeType(value="GLsizeiptr") long size, @NativeType(value="GLbitfield") int flags) {
        GL44C.glBufferStorage((int)target, (long)size, (int)flags);
    }

    public static void glBufferStorage(@NativeType(value="GLenum") int target, @NativeType(value="void const *") ByteBuffer data, @NativeType(value="GLbitfield") int flags) {
        GL44C.glBufferStorage((int)target, (ByteBuffer)data, (int)flags);
    }

    public static void glBufferStorage(@NativeType(value="GLenum") int target, @NativeType(value="void const *") ShortBuffer data, @NativeType(value="GLbitfield") int flags) {
        GL44C.glBufferStorage((int)target, (ShortBuffer)data, (int)flags);
    }

    public static void glBufferStorage(@NativeType(value="GLenum") int target, @NativeType(value="void const *") IntBuffer data, @NativeType(value="GLbitfield") int flags) {
        GL44C.glBufferStorage((int)target, (IntBuffer)data, (int)flags);
    }

    public static void glBufferStorage(@NativeType(value="GLenum") int target, @NativeType(value="void const *") FloatBuffer data, @NativeType(value="GLbitfield") int flags) {
        GL44C.glBufferStorage((int)target, (FloatBuffer)data, (int)flags);
    }

    public static void glBufferStorage(@NativeType(value="GLenum") int target, @NativeType(value="void const *") DoubleBuffer data, @NativeType(value="GLbitfield") int flags) {
        GL44C.glBufferStorage((int)target, (DoubleBuffer)data, (int)flags);
    }

    public static native void nglNamedBufferStorageEXT(int var0, long var1, long var3, int var5);

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="GLsizeiptr") long size, @NativeType(value="GLbitfield") int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, size, 0L, flags);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") ByteBuffer data, @NativeType(value="GLbitfield") int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data), flags);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") ShortBuffer data, @NativeType(value="GLbitfield") int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, Integer.toUnsignedLong(data.remaining()) << 1, MemoryUtil.memAddress((ShortBuffer)data), flags);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") IntBuffer data, @NativeType(value="GLbitfield") int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, Integer.toUnsignedLong(data.remaining()) << 2, MemoryUtil.memAddress((IntBuffer)data), flags);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") FloatBuffer data, @NativeType(value="GLbitfield") int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, Integer.toUnsignedLong(data.remaining()) << 2, MemoryUtil.memAddress((FloatBuffer)data), flags);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") DoubleBuffer data, @NativeType(value="GLbitfield") int flags) {
        ARBBufferStorage.nglNamedBufferStorageEXT(buffer, Integer.toUnsignedLong(data.remaining()) << 3, MemoryUtil.memAddress((DoubleBuffer)data), flags);
    }

    public static void glBufferStorage(@NativeType(value="GLenum") int target, @NativeType(value="void const *") short[] data, @NativeType(value="GLbitfield") int flags) {
        GL44C.glBufferStorage((int)target, (short[])data, (int)flags);
    }

    public static void glBufferStorage(@NativeType(value="GLenum") int target, @NativeType(value="void const *") int[] data, @NativeType(value="GLbitfield") int flags) {
        GL44C.glBufferStorage((int)target, (int[])data, (int)flags);
    }

    public static void glBufferStorage(@NativeType(value="GLenum") int target, @NativeType(value="void const *") float[] data, @NativeType(value="GLbitfield") int flags) {
        GL44C.glBufferStorage((int)target, (float[])data, (int)flags);
    }

    public static void glBufferStorage(@NativeType(value="GLenum") int target, @NativeType(value="void const *") double[] data, @NativeType(value="GLbitfield") int flags) {
        GL44C.glBufferStorage((int)target, (double[])data, (int)flags);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") short[] data, @NativeType(value="GLbitfield") int flags) {
        long __functionAddress = GL.getICD().glNamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((int)buffer, (long)(Integer.toUnsignedLong(data.length) << 1), (short[])data, (int)flags, (long)__functionAddress);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") int[] data, @NativeType(value="GLbitfield") int flags) {
        long __functionAddress = GL.getICD().glNamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((int)buffer, (long)(Integer.toUnsignedLong(data.length) << 2), (int[])data, (int)flags, (long)__functionAddress);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") float[] data, @NativeType(value="GLbitfield") int flags) {
        long __functionAddress = GL.getICD().glNamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((int)buffer, (long)(Integer.toUnsignedLong(data.length) << 2), (float[])data, (int)flags, (long)__functionAddress);
    }

    public static void glNamedBufferStorageEXT(@NativeType(value="GLuint") int buffer, @NativeType(value="void const *") double[] data, @NativeType(value="GLbitfield") int flags) {
        long __functionAddress = GL.getICD().glNamedBufferStorageEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((int)buffer, (long)(Integer.toUnsignedLong(data.length) << 3), (double[])data, (int)flags, (long)__functionAddress);
    }

    static {
        GL.initialize();
    }
}

