/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Canvas;
import java.awt.Container;
import java.awt.Frame;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowCloseCallback;
import org.lwjgl.glfw.GLFWWindowCloseCallbackI;
import org.lwjgl.glfw.GLFWWindowPosCallback;
import org.lwjgl.glfw.GLFWWindowPosCallbackI;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.DrawableGL;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Sync;
import org.lwjgl.system.Struct;

public class Display {
    private static final DisplayMode desktop_mode;
    private static String title;
    private static long handle;
    private static boolean resizable;
    private static DisplayMode current_mode;
    private static int width;
    private static int height;
    private static int frameBufferWidth;
    private static int frameBufferHeight;
    private static int x;
    private static int y;
    private static boolean fullscreen;
    private static boolean window_resized;
    private static boolean window_created;
    private static GLFWFramebufferSizeCallback frameBufferSizeCallback;
    private static GLFWWindowSizeCallback sizeCallback;
    private static GLFWWindowPosCallback moveCallback;
    private static GLFWWindowCloseCallback closeCallback;
    private static ByteBuffer[] cached_icons;
    private static IntBuffer buffX;
    private static IntBuffer buffY;
    protected static DrawableGL drawable;
    private static Canvas parent;

    private Display() {
    }

    public static DisplayMode getDisplayMode() {
        return current_mode;
    }

    public static int setIcon(ByteBuffer[] icons) {
        if (cached_icons != icons) {
            cached_icons = new ByteBuffer[icons.length];
            for (int i = 0; i < icons.length; ++i) {
                Display.cached_icons[i] = BufferUtils.createByteBuffer((int)icons[i].capacity());
                int old_position = icons[i].position();
                cached_icons[i].put(icons[i]);
                icons[i].position(old_position);
                cached_icons[i].flip();
            }
        }
        if (Display.isCreated()) {
            GLFW.glfwSetWindowIcon((long)handle, (GLFWImage.Buffer)Display.iconsToGLFWBuffer(cached_icons));
            return 1;
        }
        return 0;
    }

    public static DisplayMode getDesktopDisplayMode() {
        return desktop_mode;
    }

    private static GLFWImage.Buffer iconsToGLFWBuffer(ByteBuffer[] icons) {
        GLFWImage.Buffer buffer = GLFWImage.create((int)icons.length);
        for (ByteBuffer icon : icons) {
            int size = icon.limit() / 4;
            int dimension = (int)Math.sqrt(size);
            GLFWImage image = GLFWImage.malloc();
            buffer.put((Struct)image.set(dimension, dimension, icon));
        }
        buffer.flip();
        return buffer;
    }

    public static void update() {
        Display.update(true);
    }

    public static void update(boolean processMessages) {
        if (!Display.isCreated()) {
            return;
        }
        window_resized = false;
        GLFW.glfwPollEvents();
        if (processMessages) {
            if (Mouse.isCreated()) {
                Mouse.poll();
            }
            if (Keyboard.isCreated()) {
                Keyboard.poll();
            }
            if (Controllers.isCreated()) {
                Controllers.poll();
            }
        }
        Display.swapBuffers();
    }

    public static void swapBuffers() {
        GLFW.glfwSwapBuffers((long)handle);
    }

    public static void create() throws LWJGLException {
        Display.create(new PixelFormat());
    }

    public static void create(PixelFormat pixelFormat, ContextAttribs attribs) throws LWJGLException {
        Display.create(pixelFormat);
    }

    public static void create(PixelFormat pixelFormat) throws LWJGLException {
        GLFW.glfwWindowHint((int)135178, (int)pixelFormat.getAccumulationBitsPerPixel());
        GLFW.glfwWindowHint((int)135172, (int)pixelFormat.getAlphaBits());
        GLFW.glfwWindowHint((int)135179, (int)pixelFormat.getAuxBuffers());
        GLFW.glfwWindowHint((int)135173, (int)pixelFormat.getDepthBits());
        GLFW.glfwWindowHint((int)135181, (int)pixelFormat.getSamples());
        GLFW.glfwWindowHint((int)135174, (int)pixelFormat.getStencilBits());
        GLFW.glfwWindowHint((int)131075, (int)(resizable ? 1 : 0));
        long monitor = 0L;
        if (current_mode.isFullscreenCapable()) {
            monitor = GLFW.glfwGetPrimaryMonitor();
        }
        if ((handle = GLFW.glfwCreateWindow((int)current_mode.getWidth(), (int)current_mode.getHeight(), (CharSequence)title, (long)monitor, (long)0L)) == 0L) {
            throw new LWJGLException("Display could not be created");
        }
        frameBufferSizeCallback = GLFWFramebufferSizeCallback.create(Display::frameBufferResizeCallback);
        sizeCallback = GLFWWindowSizeCallback.create(Display::resizeCallback);
        moveCallback = GLFWWindowPosCallback.create(Display::moveCallback);
        closeCallback = GLFWWindowCloseCallback.create(Display::closeCallback);
        GLFW.glfwSetWindowCloseCallback((long)handle, (GLFWWindowCloseCallbackI)closeCallback);
        GLFW.glfwSetWindowSizeCallback((long)handle, (GLFWWindowSizeCallbackI)sizeCallback);
        GLFW.glfwSetFramebufferSizeCallback((long)handle, (GLFWFramebufferSizeCallbackI)frameBufferSizeCallback);
        GLFW.glfwSetWindowPosCallback((long)handle, (GLFWWindowPosCallbackI)moveCallback);
        drawable = new DrawableGL();
        GLFW.glfwMakeContextCurrent((long)handle);
        GL.createCapabilities();
        Display.createWindow();
    }

    public static void closeCallback(long window) {
        if (window == handle && parent != null) {
            Container rootParent = parent.getParent();
            if (rootParent == null) {
                return;
            }
            while (rootParent.getParent() != null) {
                rootParent = rootParent.getParent();
            }
            if (rootParent instanceof Frame) {
                Frame f = (Frame)rootParent;
                f.dispose();
            }
        }
    }

    public static void moveCallback(long window, int x, int y) {
        if (Display.isFullscreen()) {
            return;
        }
        if (window == handle) {
            Display.x = x;
            Display.y = y;
        }
    }

    public static Drawable getDrawable() {
        return drawable;
    }

    public static void setParent(Canvas canvas) throws LWJGLException {
        Container rootParent;
        if (canvas == parent) {
            return;
        }
        if (parent != null) {
            rootParent = parent.getParent();
            if (rootParent == null) {
                return;
            }
            while (rootParent.getParent() != null) {
                rootParent = rootParent.getParent();
            }
            rootParent.setVisible(true);
        }
        parent = canvas;
        if (canvas == null) {
            return;
        }
        width = canvas.getWidth();
        height = canvas.getHeight();
        Display.setDisplayMode(new DisplayMode(width, height));
        rootParent = parent.getParent();
        if (rootParent == null) {
            return;
        }
        while (rootParent.getParent() != null) {
            rootParent = rootParent.getParent();
        }
        rootParent.setVisible(false);
    }

    public static void setLocation(int new_x, int new_y) {
        x = new_x;
        y = new_y;
        if (Display.isCreated() && !Display.isFullscreen()) {
            GLFW.glfwSetWindowPos((long)handle, (int)x, (int)y);
        }
    }

    public static void setFullscreen(boolean fullscreen) throws LWJGLException {
        if (Display.isFullscreen() == fullscreen) {
            return;
        }
        GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor());
        Display.setDisplayModeAndFullscreenInternal(fullscreen, new DisplayMode(vidMode.width(), vidMode.height(), vidMode.redBits() + vidMode.greenBits() + vidMode.blueBits(), vidMode.refreshRate()));
    }

    public static void setDisplayMode(DisplayMode mode) throws LWJGLException {
        Display.setDisplayModeAndFullscreen(mode);
    }

    public static void setDisplayModeAndFullscreen(DisplayMode mode) throws LWJGLException {
        Display.setDisplayModeAndFullscreenInternal(mode.isFullscreenCapable(), mode);
    }

    private static void setDisplayModeAndFullscreenInternal(boolean fullscreen, DisplayMode mode) throws LWJGLException {
        if (mode == null) {
            throw new NullPointerException("mode must be non-null");
        }
        DisplayMode old_mode = current_mode;
        current_mode = mode;
        boolean was_fullscreen = Display.isFullscreen();
        Display.fullscreen = fullscreen;
        if (!Display.isCreated()) {
            return;
        }
        if (Display.isFullscreen()) {
            long primaryMonitor = GLFW.glfwGetPrimaryMonitor();
            GLFW.glfwGetMonitorPos((long)primaryMonitor, (IntBuffer)buffX, (IntBuffer)buffY);
            GLFW.glfwSetWindowMonitor((long)handle, (long)primaryMonitor, (int)buffX.get(), (int)buffY.get(), (int)current_mode.getWidth(), (int)current_mode.getHeight(), (int)current_mode.getFrequency());
            buffX.flip();
            buffY.flip();
        } else {
            GLFW.glfwSetWindowMonitor((long)handle, (long)0L, (int)x, (int)y, (int)current_mode.getWidth(), (int)current_mode.getHeight(), (int)current_mode.getFrequency());
            GLFW.glfwSetWindowSize((long)handle, (int)current_mode.getWidth(), (int)current_mode.getHeight());
        }
        Display.refreshSizes();
    }

    private static void createWindow() throws LWJGLException {
        if (Display.isCreated()) {
            return;
        }
        GLFW.glfwSetWindowAttrib((long)handle, (int)131075, (int)(resizable ? 1 : 0));
        window_created = true;
        Display.setDisplayModeAndFullscreenInternal(Display.isFullscreen(), current_mode);
        GLFW.glfwSetWindowPos((long)handle, (int)Display.getWindowX(), (int)Display.getWindowY());
        Display.initControls();
        if (cached_icons != null) {
            Display.setIcon(cached_icons);
        } else {
            Display.setIcon(new ByteBuffer[]{LWJGLUtil.LWJGLIcon32x32, LWJGLUtil.LWJGLIcon16x16});
        }
        GLFW.glfwShowWindow((long)handle);
        GLFW.glfwFocusWindow((long)handle);
    }

    static boolean getPrivilegedBoolean(final String property_name) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(property_name);
            }
        });
    }

    private static void initControls() {
        if (!Display.getPrivilegedBoolean("org.lwjgl.opengl.Display.noinput")) {
            if (!Mouse.isCreated() && !Display.getPrivilegedBoolean("org.lwjgl.opengl.Display.nomouse")) {
                try {
                    Mouse.create();
                }
                catch (LWJGLException e) {
                    e.printStackTrace(System.err);
                }
            }
            if (!Keyboard.isCreated() && !Display.getPrivilegedBoolean("org.lwjgl.opengl.Display.nokeyboard")) {
                try {
                    Keyboard.create();
                }
                catch (LWJGLException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    public static DisplayMode[] getAvailableDisplayModes() {
        long primaryMonitor = GLFW.glfwGetPrimaryMonitor();
        if (primaryMonitor == 0L) {
            return new DisplayMode[0];
        }
        GLFWVidMode.Buffer videoModes = GLFW.glfwGetVideoModes((long)primaryMonitor);
        if (videoModes == null) {
            return new DisplayMode[0];
        }
        ArrayList modes = new ArrayList();
        videoModes.iterator().forEachRemaining(mode -> modes.add(new DisplayMode(mode.width(), mode.height(), mode.redBits() + mode.blueBits() + mode.greenBits(), mode.refreshRate())));
        return modes.toArray(new DisplayMode[0]);
    }

    private static void refreshSizes() {
        GLFW.glfwPollEvents();
        int[] w = new int[1];
        int[] h = new int[1];
        GLFW.glfwGetFramebufferSize((long)handle, (int[])w, (int[])h);
        frameBufferWidth = w[0];
        frameBufferHeight = h[0];
        GLFW.glfwGetWindowSize((long)handle, (int[])w, (int[])h);
        width = w[0];
        height = h[0];
    }

    private static void frameBufferResizeCallback(long window, int width, int height) {
        if (window == handle) {
            window_resized = true;
            frameBufferWidth = width;
            frameBufferHeight = height;
            if (parent != null) {
                parent.setSize(frameBufferWidth, frameBufferHeight);
            }
        }
    }

    private static void resizeCallback(long window, int width, int height) {
        if (window == handle) {
            window_resized = true;
            Display.width = width;
            Display.height = height;
            if (parent != null) {
                parent.setSize(Display.width, Display.height);
            }
        }
    }

    private static void destroyWindow() {
        GLFW.glfwDestroyWindow((long)handle);
        handle = 0L;
        if (sizeCallback != null) {
            sizeCallback.free();
            sizeCallback = null;
        }
        if (moveCallback != null) {
            moveCallback.free();
            moveCallback = null;
        }
        if (closeCallback != null) {
            closeCallback.free();
            closeCallback = null;
        }
        window_created = false;
    }

    public static void destroy() {
        if (!Display.isCreated()) {
            return;
        }
        if (Mouse.isCreated()) {
            Mouse.destroy();
        }
        if (Keyboard.isCreated()) {
            Keyboard.destroy();
        }
        Display.destroyWindow();
    }

    public static boolean isCreated() {
        return window_created;
    }

    public static boolean isCloseRequested() {
        return GLFW.glfwWindowShouldClose((long)handle);
    }

    public static boolean isVisible() {
        return GLFW.glfwGetWindowAttrib((long)handle, (int)131074) == 0;
    }

    public static boolean isActive() {
        return GLFW.glfwGetWindowAttrib((long)handle, (int)131073) == 1;
    }

    public static void setResizable(boolean isResizable) {
        resizable = isResizable;
        if (Display.isCreated()) {
            GLFW.glfwSetWindowAttrib((long)handle, (int)131075, (int)(resizable ? 1 : 0));
        }
    }

    public static void sync(int fps) {
        Sync.sync(fps);
    }

    public static String getTitle() {
        return title;
    }

    public static void setTitle(String newTitle) {
        if (newTitle == null) {
            newTitle = "";
        }
        title = newTitle;
        if (Display.isCreated()) {
            GLFW.glfwSetWindowTitle((long)handle, (CharSequence)title);
        }
    }

    public static void setVSyncEnabled(boolean enabled) {
        if (!Display.isCreated()) {
            return;
        }
        GLFW.glfwSwapInterval((int)(enabled ? 1 : 0));
    }

    private static int getWindowX() {
        if (!Display.isFullscreen()) {
            if (x == -1) {
                return Math.max(0, (desktop_mode.getWidth() - current_mode.getWidth()) / 2);
            }
            return x;
        }
        return 0;
    }

    private static int getWindowY() {
        if (!Display.isFullscreen()) {
            if (y == -1) {
                return Math.max(0, (desktop_mode.getHeight() - current_mode.getHeight()) / 2);
            }
            return y;
        }
        return 0;
    }

    public static int getX() {
        if (Display.isFullscreen()) {
            return 0;
        }
        return x;
    }

    public static int getY() {
        if (Display.isFullscreen()) {
            return 0;
        }
        return y;
    }

    public static int getWindowWidth() {
        return width;
    }

    public static int getWindowHeight() {
        return height;
    }

    public static int getWidth() {
        return frameBufferWidth;
    }

    public static int getHeight() {
        return frameBufferHeight;
    }

    public static boolean isFullscreen() {
        return fullscreen;
    }

    public static boolean wasResized() {
        return window_resized;
    }

    public static long getHandle() {
        return handle;
    }

    static {
        GLFWVidMode vidMode;
        title = "Game";
        handle = 0L;
        width = 0;
        height = 0;
        frameBufferWidth = 0;
        frameBufferHeight = 0;
        x = -1;
        y = -1;
        buffX = BufferUtils.createIntBuffer((int)1);
        buffY = BufferUtils.createIntBuffer((int)1);
        drawable = null;
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        if (GLFW.glfwInit()) {
            new ExceptionInInitializerError("Unable to initialize GLFW");
        }
        desktop_mode = (vidMode = GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor())) == null ? null : new DisplayMode(vidMode.width(), vidMode.height(), vidMode.redBits() + vidMode.greenBits() + vidMode.blueBits(), vidMode.refreshRate());
        current_mode = desktop_mode;
    }
}

