/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import javax.annotation.Nullable;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.ContextCapabilities;

public class GLContext {
    private static final ThreadLocal<ContextCapabilities> current_capabilities = new ThreadLocal();

    public static ContextCapabilities getCapabilities() {
        ContextCapabilities caps = GLContext.getCapabilitiesImpl();
        if (caps == null) {
            try {
                ContextCapabilities created = new ContextCapabilities(false);
                GLContext.setCapabilities(created);
                return created;
            }
            catch (LWJGLException e) {
                throw new RuntimeException("No OpenGL context found in the current thread and could not create!", e);
            }
        }
        return caps;
    }

    @Nullable
    private static ContextCapabilities getCapabilitiesImpl() {
        return GLContext.getThreadLocalCapabilities();
    }

    @Nullable
    private static ContextCapabilities getThreadLocalCapabilities() {
        return current_capabilities.get();
    }

    static void setCapabilities(ContextCapabilities capabilities) {
        current_capabilities.set(capabilities);
    }
}

