/*
 * Decompiled with CFR 0.152.
 */
package org.mcphackers.legacylwjgl3.implementation.glfw;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorEnterCallback;
import org.lwjgl.glfw.GLFWCursorEnterCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.EventQueue;
import org.mcphackers.legacylwjgl3.implementation.MouseImplementation;

public class GLFWMouseImplementation
implements MouseImplementation {
    private GLFWMouseButtonCallbackI buttonCallback;
    private GLFWCursorPosCallbackI posCallback;
    private GLFWScrollCallbackI scrollCallback;
    private GLFWCursorEnterCallbackI cursorEnterCallback;
    private long windowHandle;
    private boolean isInsideWindow;
    private static final int WHEEL_SCALE = 120;
    private final EventQueue event_queue = new EventQueue(22);
    private final ByteBuffer tmp_event = ByteBuffer.allocate(22);
    private int last_x;
    private int last_y;
    private int accum_dx;
    private int accum_dy;
    private int accum_dz;
    private boolean grab;
    private boolean ignoreFirstMove = true;
    private boolean ignoreNext;
    private byte[] button_states = new byte[this.getButtonCount()];
    private double[] x_coord = new double[1];
    private double[] y_coord = new double[1];

    @Override
    public void createMouse() {
        this.windowHandle = Display.getHandle();
        if (GLFW.glfwRawMouseMotionSupported() && !Mouse.getPrivilegedBoolean("org.lwjgl.input.Mouse.disableRawInput")) {
            GLFW.glfwSetInputMode((long)this.windowHandle, (int)208901, (int)1);
        }
        this.buttonCallback = new GLFWMouseButtonCallbackI(){

            public void invoke(long window, int button, int action, int mods) {
                byte state = action == 1 ? (byte)1 : 0;
                GLFWMouseImplementation.this.putMouseEvent((byte)button, state, 0, System.nanoTime());
                if (button < GLFWMouseImplementation.this.button_states.length) {
                    ((GLFWMouseImplementation)GLFWMouseImplementation.this).button_states[button] = state;
                }
            }
        };
        this.posCallback = new GLFWCursorPosCallbackI(){

            public void invoke(long window, double xpos, double ypos) {
                if (GLFWMouseImplementation.this.ignoreNext) {
                    GLFWMouseImplementation.this.ignoreNext = false;
                    return;
                }
                int x = (int)GLFWMouseImplementation.this.scaledWidth(xpos);
                int y = GLFWMouseImplementation.this.transformY((int)GLFWMouseImplementation.this.scaledHeight(ypos));
                long nanos = System.nanoTime();
                if (GLFWMouseImplementation.this.ignoreFirstMove) {
                    GLFWMouseImplementation.this.last_x = x;
                    GLFWMouseImplementation.this.last_y = y;
                    GLFWMouseImplementation.this.ignoreFirstMove = false;
                }
                int dx = x - GLFWMouseImplementation.this.last_x;
                int dy = y - GLFWMouseImplementation.this.last_y;
                if (GLFWMouseImplementation.this.grab && GLFWMouseImplementation.this.isInsideWindow()) {
                    GLFWMouseImplementation.this.accum_dx = GLFWMouseImplementation.this.accum_dx + dx;
                    GLFWMouseImplementation.this.accum_dy = GLFWMouseImplementation.this.accum_dy + dy;
                }
                if (GLFWMouseImplementation.this.grab) {
                    GLFWMouseImplementation.this.putMouseEventWithCoords((byte)-1, (byte)0, dx, dy, 0, nanos);
                } else {
                    GLFWMouseImplementation.this.putMouseEventWithCoords((byte)-1, (byte)0, x, y, 0, nanos);
                }
                GLFWMouseImplementation.this.last_x = x;
                GLFWMouseImplementation.this.last_y = y;
            }
        };
        this.scrollCallback = GLFWScrollCallback.create((window, xoffset, yoffset) -> {
            this.accum_dz = (int)((double)this.accum_dz + yoffset * 120.0);
            this.putMouseEvent((byte)-1, (byte)0, (int)(yoffset * 120.0), System.nanoTime());
        });
        this.cursorEnterCallback = GLFWCursorEnterCallback.create((window, entered) -> {
            this.isInsideWindow = entered;
        });
        GLFW.glfwSetMouseButtonCallback((long)this.windowHandle, (GLFWMouseButtonCallbackI)this.buttonCallback);
        GLFW.glfwSetCursorPosCallback((long)this.windowHandle, (GLFWCursorPosCallbackI)this.posCallback);
        GLFW.glfwSetScrollCallback((long)this.windowHandle, (GLFWScrollCallbackI)this.scrollCallback);
        GLFW.glfwSetCursorEnterCallback((long)this.windowHandle, (GLFWCursorEnterCallbackI)this.cursorEnterCallback);
    }

    private double scaledWidth(double mouseX) {
        return this.grab ? mouseX : mouseX * (double)Display.getWidth() / (double)Display.getWindowWidth();
    }

    private double scaledHeight(double mouseY) {
        return this.grab ? mouseY : mouseY * (double)Display.getHeight() / (double)Display.getWindowHeight();
    }

    private void putMouseEvent(byte button, byte state, int dz, long nanos) {
        if (this.grab) {
            this.putMouseEventWithCoords(button, state, 0, 0, dz, nanos);
        } else {
            this.putMouseEventWithCoords(button, state, this.last_x, this.last_y, dz, nanos);
        }
    }

    private void putMouseEventWithCoords(byte button, byte state, int x, int y, int dz, long nanos) {
        this.tmp_event.clear();
        this.tmp_event.put(button).put(state).putInt(x).putInt(y).putInt(dz).putLong(nanos);
        this.tmp_event.flip();
        this.event_queue.putEvent(this.tmp_event);
    }

    @Override
    public void destroyMouse() {
        this.buttonCallback = null;
        this.posCallback = null;
        this.scrollCallback = null;
        this.cursorEnterCallback = null;
    }

    private void reset() {
        this.event_queue.clearEvents();
        this.accum_dy = 0;
        this.accum_dx = 0;
    }

    @Override
    public void pollMouse(IntBuffer coord_buffer, ByteBuffer buttons_buffer) {
        if (this.grab) {
            coord_buffer.put(0, this.accum_dx);
            coord_buffer.put(1, this.accum_dy);
        } else {
            coord_buffer.put(0, this.last_x);
            coord_buffer.put(1, this.last_y);
        }
        coord_buffer.put(2, this.accum_dz);
        this.accum_dz = 0;
        this.accum_dy = 0;
        this.accum_dx = 0;
        for (int i = 0; i < this.button_states.length; ++i) {
            buttons_buffer.put(i, this.button_states[i]);
        }
    }

    @Override
    public void readMouse(ByteBuffer readBuffer) {
        this.event_queue.copyEvents(readBuffer);
    }

    private int transformY(int y) {
        return Display.getHeight() - 1 - y;
    }

    @Override
    public void setCursorPosition(int x, int y) {
        GLFW.glfwSetCursorPos((long)this.windowHandle, (double)(x * Display.getWindowWidth() / Display.getWidth()), (double)(y * Display.getWindowHeight() / Display.getHeight()));
        GLFW.glfwGetCursorPos((long)this.windowHandle, (double[])this.x_coord, (double[])this.y_coord);
        this.last_x = (int)this.scaledWidth(this.x_coord[0]);
        this.last_y = this.transformY((int)this.scaledHeight(this.y_coord[0]));
        this.ignoreNext = true;
        this.ignoreFirstMove = true;
    }

    @Override
    public void grabMouse(boolean grab) {
        if (grab && !this.grab) {
            this.ignoreFirstMove = true;
        }
        this.grab = grab;
        GLFW.glfwSetInputMode((long)this.windowHandle, (int)208897, (int)(grab ? 212995 : 212993));
        this.reset();
    }

    @Override
    public boolean hasWheel() {
        return true;
    }

    @Override
    public int getButtonCount() {
        return 8;
    }

    @Override
    public boolean isInsideWindow() {
        return this.isInsideWindow;
    }

    @Override
    public int getNativeCursorCapabilities() {
        return 0;
    }
}

